/*
   This program starts a child process and wants the child
   to inherit (share) this program's stdin and stdout streams.
   But this cannot be done in Java 6 (or earlier). So we fake
   it (in a really dumb way).

   In this program, the parent reads one line from its
   stdin, writes that line to the child's stdin, then
   the parent goes to the "other end" of the child
   process and reads an output line form the child's
   stdout, and then writes that line to its own stdout.
   This is prone to deadlock!


   The structure of this program is similar to the program
   Java6_RedirectChildStdinStdoutToFiles_ver2.java


   Important: Notice that this program is logically the
   same as the following command line.

   C:\> java Double

   In the case of the above command line, the shell
   program (cmd.exe) runs the program Double.class
   and has it inherit the shell's stdin and stdout.
   In the case of this program, this program itself
   runs Double.class and makes sure that Double.class
   inherit's this program's stdin and stdout. So this
   program is acting like a very simple shell program.
*/
import java.util.Scanner;
import java.io.*;

public class Java6_ChildInheritsStdStreams_ver2
{
   public static void main(String[] args) throws IOException, InterruptedException
   {
      // Create a command line for running the child.
      String cmd = "java Double";
      // Execute the filter.
      Process process = Runtime.getRuntime().exec(cmd);

      // Create a stream that writes data to the child's stdin stream.
      PrintStream stdinOfChild =  new PrintStream( process.getOutputStream() );
      // Create a stream that reads data from the child's stdout stream.
      Scanner stdoutOfChild = new Scanner( process.getInputStream() );

      // Create a Scanner object to make it easier to use System.in
      Scanner scanner = new Scanner( System.in );


      // Copy one line at a time from the parent's stdin into the child's stdin,
      // and then copy that line from the child's stdout into the parent's stdout.
      while ( scanner.hasNextLine() )
      {
         String oneLine1 = scanner.nextLine();       // read a line from stdin
         stdinOfChild.println( oneLine1 );           // send it to the child
         stdinOfChild.flush();  //THIS IS IMPORTANT (otherwise the parent will just hang)
         String oneLine2 = stdoutOfChild.nextLine(); // wait for the child to process the line
         System.out.println( oneLine2 );             // write the resulting line to stdout
      }

      // Wait for the child to finish its work.
      process.waitFor();  // this throws InterruptedException
   }
}

/*
   IMPORTANT:
   Explain why this program will hang, and never terminate,
   if the child process is the program MakeOneLine.java.
*/